
//HTG12848-ST7565R
//Parallel
//2016.7.18

#include <reg51.h>
#include <intrins.h>
#define uchar unsigned char
#define  uint unsigned int

/****************parallel*************************/

sbit	R_S=	P3^5;
sbit	RES=	P3^4;
sbit	W_R= 	P3^2;
sbit	R_D=	P3^3;
sbit    C_S=    P3^7;



uchar Page=0xb2;			
void WrateC(uchar cmd);		
void WrateD(uchar dat);		
void LcdInit();			
void Delayms(uchar ms);			
void WriteEnglish(uchar col,uchar pag,uchar *ptr);			
void Setadd(uchar xl,uchar yl);


char code Hanzi[]={
0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,
0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0xFE,0x00,0x1C,0x02,0x82,
0x42,0x3C,0x00,0x1C,0xA2,0x42,0xA2,0x1C,0x00,0x00,0x24,0x18,0x7E,0x18,0x24,0x00,
0x00,0xE0,0x1C,0xE2,0x00,0x1C,0xA2,0x42,0xA2,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xF0,0x0C,0x02,0x01,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFC,
0x02,0x02,0x02,0x1C,0x00,0xFE,0x1C,0xE0,0x00,0xE0,0x1C,0xFE,0x00,0x08,0xFE,0x00,
0x1C,0x02,0x82,0x42,0x3C,0x00,0x1C,0xA2,0x42,0xA2,0x1C,0x00,0x00,0x00,0xE0,0x1C,
0xE2,0x00,0x1C,0xA2,0x42,0xA2,0x1C,0x00,0xFE,0x42,0x42,0x42,0xBC,0x00,0x00,0x00,
0x00,0x01,0x02,0x0C,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x00,0x18,0x16,0x11,
0x10,0x10,0x00,0x0F,0x10,0x10,0x10,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x03,0x02,0x02,0x1F,0x02,0x0F,0x10,0x10,0x10,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0x0C,0x10,0x20,0x40,0x40,0x00,0x00,0x1F,0x10,0x10,0x10,0x0F,
0x10,0x10,0x10,0x0C,0x00,0x1F,0x00,0x00,0x07,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,
0x18,0x16,0x11,0x10,0x10,0x00,0x0F,0x10,0x10,0x10,0x0F,0x00,0x00,0x03,0x02,0x02,
0x1F,0x02,0x0F,0x10,0x10,0x10,0x0F,0x00,0x1F,0x10,0x10,0x10,0x0F,0x00,0x00,0x40,
0x40,0x20,0x10,0x0C,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x80,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x80,0x00,0x00,0x00,0xC0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x05,0x09,0x11,0xE1,0xD9,0x07,0x08,0x06,0x03,0xFA,0x82,
0x02,0x0A,0x06,0x02,0x00,0x10,0x10,0xF3,0x01,0x00,0xFF,0x81,0x40,0x00,0xFF,0x01,
0x81,0x01,0xFF,0x00,0x00,0x10,0x08,0xFC,0x07,0x01,0x7C,0xA5,0x25,0x25,0xFF,0x25,
0x25,0x25,0x7D,0x01,0x00,0x00,0x00,0x00,0xFF,0x88,0x88,0x88,0x88,0xFF,0x88,0x88,
0x88,0x88,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0xFE,0x01,0x01,0x01,0x0E,0x00,0xFF,
0x01,0x01,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x88,0x84,0x93,0x90,0x90,0x8B,0x88,0x84,0x83,0x80,0x81,
0x86,0x8C,0x98,0x88,0x80,0x90,0x88,0x87,0x88,0x90,0x91,0x90,0x90,0x90,0x97,0x90,
0x90,0x91,0x90,0x90,0x80,0x80,0x80,0x9F,0x80,0x90,0x90,0x88,0x85,0x83,0x84,0x84,
0x8C,0x88,0x98,0x88,0x80,0xA0,0x90,0x8C,0x83,0x80,0x80,0x80,0x80,0xBF,0x80,0x80,
0x90,0xA0,0x9F,0x80,0x80,0x8F,0x88,0x88,0x88,0x87,0x88,0x88,0x88,0x86,0x80,0x8F,
0x88,0x88,0x88,0x87,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF

};
//-----------------------------------
// Delay Routine
//-----------------------------------

void delay(uint m)
{
	uint j;
	uint i;
	
	for(i=0; i<m; i++)
	    for(j=0; j<100; j++)
	        _nop_();_nop_();
}

void Clear()
{
   unsigned char  i,j,m=0;
   for(i=0;i<8;i++)   
    {
     Setadd(0,i); 	  	  
     for(j=0;j<128;j++) 
          WrateD(0x00);
     }
}

//initialize
void LcdInit()
{		
	RES=0;
	delay(50);
	RES=1;
	delay(20);						
	WrateC(0xe2);
	WrateC(0xA2);
	WrateC(0xA0);
	WrateC(0xc8);
	WrateC(0x2c);
	WrateC(0x2e);
	WrateC(0x2F);
	WrateC(0x81);
	WrateC(0x08);
	WrateC(0x25);
	WrateC(0xAF);
	WrateC(0x40);
	Clear();
}
	
void Hanzi_Disp(void)  
{
  unsigned char   i,j,k=0;
  WrateC(0x40);
      for(i=0;i<8;i++)
	{	  
         Setadd(0,i); 
         for(j=0;j<128;j++)	
	   WrateD(Hanzi[i*128+j]);	
	} 
	    	 
}  

void Display(unsigned char sda,unsigned char sda1)
{
   unsigned char  i,j;
   for(i=0;i<8;i++)   
    {
     WrateC(Page+i);   
 	 WrateC(0x10);
	 WrateC(0x00);	  
       for(j=0;j<128;j++) 
          { WrateD(sda);
            WrateD(sda1);
          }
    }
}  

void main()
{  
while(1)
{	
	  LcdInit();
	  
      Display(0xFF,0xFF);
	  delay(1000); 

      Display(0x00,0x00);
	  delay(1000);
	  
      Display(0x55,0xAA);
	  delay(1000);

      Display(0xAA,0x55);
	  delay(1000);
	  
      Display(0xFF,0x00);
	  delay(1000);

      Display(0x00,0xFF);
	  delay(1000);

      Hanzi_Disp();  
	  delay(1000); 
	  Clear();
	
}
}


void Setadd(uchar xl,uchar yl)
{    uchar i;
     i=(xl+0)&0x0f; //SEG0~SEG127
     xl=(xl>>4)+0x10;
     WrateC(0xb2+yl); 	  
	 WrateC(xl);
 	 WrateC(i);	
}

void WrateC(uchar cmd) 
{
	R_S=0;	
	C_S=0;						
	W_R=0;
	R_D=1;
	P1=cmd;
	W_R=1;	
    C_S=1;
}


void WrateD(uchar dat)	
{
	R_S=1;
	C_S=0;						
	W_R=0;
	R_D=1;
	P1=dat;
	W_R=1;	
    C_S=1;
}





